{********************************************
; File: NoteSeq.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT NOTESEQ;
INTERFACE
USES TYPES;
CONST

{ Commands }
pitchBend = $0;
tempo = $00000001;
turnNotesOff = $00000002;
jump = $00000003;
setVibratoDepth = $00000004;
programChange = $00000005;
setRegister = $00000006;
ifGo = $00000007;
incRegister = $00000008;
decRegister = $00000009;
midiNoteOff = $0000000A;
midiNoteOn = $0000000B;
midiPolyKey = $0000000C;
midiCtlChange = $0000000D;
midiProgChange = $0000000E;
midiChnlPress = $0000000F;
midiPitchBend = $00000010;
midiSelChnlMode = $00000011;
midiSysExclusive = $00000012;
midiSysCommon = $00000013;
midiSysRealTime = $00000014;
midiSetSysExl = $00000015;
callRoutine = $0000001E;

{ Mask Values }
commandMask = $0000007F;
volumeMask = $0000007F;
chord = $00000080;
val1Mask = $00007F00;
toneMask = $00007F00;
noteMask = $00008000;
lByte = $00FF0000;  { meaning depends on midi command }
durationMask = $07FF0000;
trackMask = $78000000;
delayMask = $80000000;
hByte = $FF000000;

{ Error Codes }
noRoomMidiErr = $1A00;
noCommandErr = $1A01;  { can't understand the current SeqItem }
noRoomErr = $1A02;  { sequence is more than twelve levels deep }
startedErr = $1A03;  { Note Sequencer is already started }
noNoteErr = $1A04;  { can't find the note to be turned off by the current SeqItem }
noStartErr = $1A05;  { Note Sequencer not started yet }
instBndsErr = $1A06;  { Instrument number out of Instrument boundary range }
nsWrongVer = $1A07;  { incompatible versions of NoteSequencer and NoteSynthesizer }
TYPE
LocRecHndl = ^LocRecPtr;
LocRecPtr = ^LocRec;
LocRec = RECORD
    curPhraseItem : Integer;
    curPattItem : Integer;
    curLevel : Integer;
END;
FUNCTION ClearIncr  : Integer ;
FUNCTION GetLoc  : LocRec ;
FUNCTION GetTimer  : Integer ;
PROCEDURE SeqAllNotesOff   ;
PROCEDURE SeqBootInit   ;
PROCEDURE SeqReset   ;
PROCEDURE SeqShutDown   ;
PROCEDURE SeqStartUp ( dPageAddr:Integer; mode:Integer; updateRate:Integer; increment:Integer)  ;
FUNCTION SeqStatus  : Boolean ;
FUNCTION SeqVersion  : Integer ;
PROCEDURE SetIncr ( increment:Integer)  ;
PROCEDURE SetInstTable ( instTable:Handle)  ;
PROCEDURE SetTrkInfo ( priority:Integer; instIndex:Integer; trackNum:Integer)  ;
PROCEDURE StartInts   ;
PROCEDURE StartSeq ( errHndlrRoutine:VoidProcPtr; compRoutine:VoidProcPtr; sequence:Handle)  ;
PROCEDURE StartSeqRel ( errHandlerPtr:ProcPtr; compRoutine:ProcPtr; sequence:Handle)  ;
PROCEDURE StepSeq   ;
PROCEDURE StopInts   ;
PROCEDURE StopSeq ( next:Integer)  ;
IMPLEMENTATION
END.
